﻿window.voxco = window.voxco || {};

(function (page, $, undefined) {
    //Private functions
    function parseCurrentItem() {
        if ($("#project-data", page.context).length > 0)
            page.currentItem = JSON.parse($("#project-data", page.context).val());
    };

    //Public properties
    page.context = undefined;
    page.currentItem = undefined;
    page.itemSelector = undefined;
    page.itemMenu = undefined;
    page.datatable = undefined;
    page.listview = undefined;

    //Public functions
    page.initialize = function (context) {
        console.debug('page.initialize');

        page.context = context;

        $(page).triggerHandler("beforeInitialize");

        parseCurrentItem();

        if (page.initializeControls && _.isFunction(page.initializeControls))
            page.initializeControls();

        if (page.bindEvents && _.isFunction(page.bindEvents))
            page.bindEvents();

        if (page.itemMenu) {
            if (page.itemMenu.bindEvents && _.isFunction(page.itemMenu.bindEvents))
                page.itemMenu.bindEvents();
        }

        $(page).triggerHandler("initialize");
    };

    page.initializeControls = function () {
        console.debug('page.initializeControls');
    };

    page.bindEvents = function () {
        console.debug('page.bindEvents');
    };

    //Default page refresh. Can be overrided for custom code
    page.refresh = function () {
        console.debug('page.refresh');

        if (page.datatables)
            page.datatables.a4datatable("refresh");
    };

    page.getCurrentItemId = function () {
        return $("#survey-block", projectMenu.context).attr("data-projectId");
    };
}(window.voxco.page = window.voxco.page || {}, jQuery));